require 'rspec'

require_relative '../../module/DriverUtility'
require_relative '../rspec_helper'
require_relative '../../pages/varUtility/landing'
require_relative '../../common/accessVarUtility'
require_relative '../../common/common'
require_relative '../../pages/vaToolSet/home'
require_relative '../../pages/vaToolSet/userMenu'
require_relative '../../pages/landing_page'


describe '[Story VARUT-8: Utility - User Options & Logout],
          [Story VARUT-9: Utility - About Page]
          [Story VARUT-294]: Utility -- Launchpad Feature
          [Story VARUT-353: Utility - Update version in footer and about]'  do
  include DriverUtility

  before(:all) do
    initializeConfigurations(BASE_URL)
    @landing = Landing.new(@driver)
    @launchpad = Launchpad.new(@driver)
    @loginUtil = AccessVarUtility.new(@driver)
    @login = Login.new(@driver)
    @common = Common.new(@driver)
    @userMenu = UserMenu.new(@driver)
    @landing_page = LandingPage.new(@driver)

  end

  after(:all) do
    @driver.close
  end

  context 'AC#VARUT-132|TC#VARUT-137: Validate user Menu and Logout
           AC#VARUT-366|TC#VARUT-367: Update version in footer and criteria' do
    it "Login" do
      @loginUtil.access_var_utility(UserAccess7)
      @landing.rightFooter_element.when_visible(TIME_OUT_LIMIT)
      Watir::Wait.until {@landing.rightFooter == "Logged in as PROVIDER, SEVEN"}
      expect(@landing.rightFooter).to eq("Logged in as PROVIDER, SEVEN")
    end

    it "User Options" do
      @userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.userMenu_element.click
      @userMenu.menuHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.menuHeader.split("\n")[0]).to eq("User Options")
    end



    context 'AC#VARUT-179|TC#VARUT-180: Validate About Page
             AC#VARUT-366|TC#VARUT-367: Update version in footer and criteria'
    it "About Page Validation" do
      expect(@userMenu.about_element.text).to eq("About")
      @userMenu.about
      @userMenu.aboutTitle_element.when_visible(TIME_OUT_LIMIT)
      #todo: need to delete Popup modal text when defect is fixed
      expect(@userMenu.aboutTitle_element.text).to eq("Popup modal\nAbout")
      expect(@userMenu.content_element.text).to eq("VA Tool Set - v2.3.0")
      expect(@userMenu.contentLine2_element.text).to eq("The VA Tool Set provides access to utilities that allow authorized users to configure and support features in other mobile apps.")
      expect(@userMenu.contentLine3_element.text).to eq("Select the appropriate user guide for detailed tool instructions.")
    end

    context 'AC#VARUT-228|TC#VARUT-229: Validate User Guide Link'
    it "User Guide Validation" do
      @userMenu.aboutTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.aboutTitle_element.text).to eq("Popup modal\nAbout")
      @userMenu.userGuideLinkVARUT
      switchWindowToWindowHandleLast
      expect(getCurrentURL).to eq("https://IP      /va-tool-set-web/assets/pdfs/var-utility-guide.pdf")
      switchWindowToWindowHandleFirst
      @userMenu.aboutTitle_element.when_present(TIME_OUT_LIMIT)
      expect(@userMenu.aboutTitle).to eq("Popup modal\nAbout")

      @userMenu.ok_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.ok
      @userMenu.about_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.about_element.text).to eq("About")

    end

    it "Launchpad -- Navigates the user to the VA Launchpad" do
      @userMenu.menuHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.menuHeader.split("\n")[0]).to eq("User Options")
      @userMenu.launchpad_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.launchpad_element.text).to eq("Launchpad")
      sleep 1
      @userMenu.launchpad
      @common.waitWhileSpinnerPresent

      @launchpad.launchpad_eula_accept_element.when_visible(TIME_OUT_LIMIT)
      @launchpad.launchpad_eula_accept

      @launchpad.launchpadTitle_element.when_visible(TIME_OUT_LIMIT)
      expect(@launchpad.launchpadTitle).to eq("Launchpad")
      expect(@launchpad.footer_name).to eq("Logged in as PROVIDER, SEVEN - BOSTON HCS VAMC")

    end

    it "Log out - returns user to Launchpad" do
      @driver.goto(BASE_URL)
      @common.waitWhileSpinnerPresent

      @userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.userMenu_element.click
      @userMenu.menuHeader_element.when_visible(TIME_OUT_LIMIT)
      expect(@userMenu.menuHeader.split("\n")[0]).to eq("User Options")

      @landing_page.login_button_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.login_button
      @userMenu.userMenu_element.when_visible(TIME_OUT_LIMIT)
      @userMenu.userMenu_element.click
      @landing_page.logout_button_element.wait_until_present(TIME_OUT_LIMIT)
      @landing_page.logout_button

      @launchpad.launchpadTitle_element.wait_until_present(TIME_OUT_LIMIT)
      expect(@launchpad.launchpadTitle).to eq("Launchpad")

      expect(@launchpad.footer_name).to eq("Not logged in")

    end



  end
end





